* Globk command file to run back solution for orbits
*
# MOD TAH 170208: Updated to IGS14
# MOD TAH 191204: Set up to use new ECOMC and back model

# eq_file ../tables/IGS14.rename
  eq_file igb14_comb.eq
#  eq_file ../tables/IGSR3_comb.eq

  com_file back@.com
  use_prn N
  make_svs Week@.svs Z
BFIX  make_svs Week@.svs A
ALFX  make_svs Week@.svs A
xREVAL  make_svs Week@.svs A
xSUYAL  make_svs Week@.svs A
SVSA  make_svs Week@.svs A

  srt_file back@.srt

  sol_file back@.sol

* Use the bak.unc file generated from the globk_week.cmd run
#  apr_file ../tables/repro3.apr
 apr_file /net/geowk03/working/globk.igs20/soln/2316R/Week.apr
#  apr_file ../tables/Updated.apr

 in_pmu /net/geowk03/working/globk.igs20/soln/2316R/Week.pmu
LEOP in_pmu RADEVAL_B2UD.<WWWW>/B2UD<WWWW>.pmu

  out_glb @.GLX

  max_chii 80 4 10000

  apr_neu all 1 1 1 0 0 0

  apr_svs all     100 100 100 10 10 10  1R 0.001A

  prt_opt nopr era psum gdl cmd
  org_cmd glorg_dcomb.cmd
  org_opt era psum cmd gdl
GLRED org_opt psum cmd gdl
  crt_opt noprt
  bak_opt era pbop psum 

BRAD source FIX.radmod.<WWWW>
BRAD bak_file Week<WWWW>_B2UD<LAB>.bak

* NCON is no-constraint solution.
NCON apr_rad all 1R
NCON mar_rad all 365R
NCON bak_file Week<WWWW>_NCON<LAB>.bak
NCON mar_neu all 365 365 365  0 0 0

* F2UD  B-axis OPR and 2U Direct only, run purely as forward solution
* MOD TAH 200127: Week 2089; removed 4DC 4DS
#                Dir   Y   B  1DC 1DS  1YC 1YS 1BC 1BS  2DC 2DS  4DC 4DS 
F2UD apr_rad all   1   1   1    F   F    F   F   1   1    1   1    F   F 
F2UD mar_neu all 365 365 365  0 0 0

* B2UD  B-axis OPR and 2U+4U Direct only
* MOD TAH 200127: Week 2089; removed 4DC 4DS
#                Dir   Y   B  1DC 1DS  1YC 1YS 1BC 1BS  2DC 2DS  4DC 4DS 
B2UD apr_rad all   1   1   1    F   F    F   F   1   1    1   1    F   F 
B2UD mar_rad all 365 365 365    0  0    0    0 365 365  365 365    0   0
B2UD bak_file Week<WWWW>_B2UD<LAB>.bak
xB2UD mar_neu all 365 365 365  0 0 0
# Addition for bad overlaps
BADO source B2UD<LAB>.OVER.<WWWW>
* Run after B2UD and constrains process noise. 
B2UM source B2UD<LAB>.radmod.<WWWW>
B2UM bak_file Week<WWWW>_B2UM<LAB>.bak
B2UM mar_neu all 365 365 365  0 0 0
B2UM out_glb Week<WWWW><D>_B2UM.GLX
# Use the SAVE option to create IGS SINEX files with center of mass not
# forced to zero.
SAVE out_glb  Save<WWWW><D>_B2UM<LAB>.GLS
SAVE bak_file Save<WWWW>_B2UM<LAB>.bak

* BAUD  B-axis OPR and 1U and 2U Direct only
#                Dir   Y   B  1DC 1DS  1YC 1YS  1BC 1BS  2DC   2DS 4DC 4DS 
BAUD apr_rad all   1   1   1    1   1    F   F    1   1    1    1    F   F 
BAUD mar_rad all 365 365 365  365 365    0    0 365 365  365  365    0   0 
BAUD bak_file Week<WWWW>_BAUD<LAB>.bak

BAUM source BAUD.radmod.<WWWW>
BAUM bak_file Week<WWWW>_BAUM<LAB>.bak
BAUM mar_neu all 365 365 365  0 0 0
BAUM out_glb Week<WWWW><D>_BAUM.GLX

* BFIX  All peiodid radiation parameters fixed to APROIRI values!!
BFIX# radiation parameters fixed to APROIRI values! BIASED orbit.
#                Dir   Y   B  1DC 1DS  1YC 1YS  1BC 1BS  2DC  2DS  4DC 4DS 
BFIX apr_rad all   1   1   1    F   F    F   F    F   F    F    F    F   F
BFIX mar_rad all 365 365 365    0   0    0   0    0   0    0    0    0   0
BFIX mar_neu all 365 365 365  0 0 0
BFIX bak_file Week<WWWW>_BFIX<LAB>.bak

* ALFX  All orbit parameters fixed to APROIRI values!!
ALFX# All orbit fixed to APROIRI values! BASELINE MODE
#                  X   Y   Z   Vx  Yy   Vz  Rad  Ant
ALFX apr_svs all   F   F   F    F   F    F   FR   FA 
ALFX mar_neu all 365 365 365  0 0 0
ALFX bak_file Week<WWWW>_ALFX<LAB>.bak
ALFX max_chi 1000

* PL0  Plane 0 test
#                Dir   Y   B  1DC 1DS  1YC 1YS  1BC 1BS  2DC   2DS 4DC 4DS 
PL0  apr_rad all   1   1   1    1   1    F   F    1   1    1    1    F   F 

#                Dir   Y   B  1DC 1DS  1YC 1YS 1BC 1BS  2DC 2DS  4DC 4DS 
REVAL apr_rad all   1   1   1    F   F    F   F   1   1    1   1    F   F 
SUYAL apr_rad all   1   1   1    F   F    1   1   1   1    1   1    F   F 
NOPER apr_rad all   1   1   1    F   F    F   F   F   F    F   F    F   F 

# Plane 2
FULA apr_rad R730_01  1   1   1    F   F    1   1   1   1    1   1    F   F 
FULA apr_rad R747_02  1   1   1    F   F    1   1   1   1    1   1    F   F 
FULA apr_rad R744_03  1   1   1    F   F    1   1   1   1    1   1    F   F 
FULA apr_rad R859_04  1   1   1    F   F    1   1   1   1    1   1    F   F 
FULA apr_rad R856_05  1   1   1    F   F    1   1   1   1    1   1    F   F 
FULA apr_rad R745_07  1   1   1    F   F    1   1   1   1    1   1    F   F 
FULA apr_rad R743_08  1   1   1    F   F    1   1   1   1    1   1    F   F 
# Plane 4
FULA apr_rad R802_09  1   1   1    F   F    1   1   1   1    1   1    F   F
FULA apr_rad R853_11  1   1   1    F   F    1   1   1   1    1   1    F   F
FULA apr_rad R858_12  1   1   1    F   F    1   1   1   1    1   1    F   F
FULA apr_rad R721_13  1   1   1    F   F    1   1   1   1    1   1    F   F
FULA apr_rad R852_14  1   1   1    F   F    1   1   1   1    1   1    F   F
FULA apr_rad R857_15  1   1   1    F   F    1   1   1   1    1   1    F   F
FULA apr_rad R736_16  1   1   1    F   F    1   1   1   1    1   1    F   F

# Plane 0
FULA apr_rad R851_17   1   1   1    F   F    F   F   F   F    F   F    F   F
FULA apr_rad R854_18   1   1   1    F   F    F   F   F   F    F   F    F   F
FULA apr_rad R720_19   1   1   1    F   F    F   F   F   F    F   F    F   F
FULA apr_rad R719_20   1   1   1    F   F    F   F   F   F    F   F    F   F
FULA apr_rad R855_21   1   1   1    F   F    F   F   F   F    F   F    F   F
FULA apr_rad R731_22   1   1   1    F   F    F   F   F   F    F   F    F   F
FULA apr_rad R732_23   1   1   1    F   F    F   F   F   F    F   F    F   F
FULA apr_rad R801_26   1   1   1    F   F    F   F   F   F    F   F    F   F

# Plane 2
FULA mar_rad R730_01  1   1   1    F   F    1   1   1   1    1   1    F   F 
FULA mar_rad R747_02  1   1   1    F   F    1   1   1   1    1   1    F   F 
FULA mar_rad R744_03  1   1   1    F   F    1   1   1   1    1   1    F   F 
FULA mar_rad R859_04  1   1   1    F   F    1   1   1   1    1   1    F   F 
FULA mar_rad R856_05  1   1   1    F   F    1   1   1   1    1   1    F   F 
FULA mar_rad R745_07  1   1   1    F   F    1   1   1   1    1   1    F   F 
FULA mar_rad R743_08  1   1   1    F   F    1   1   1   1    1   1    F   F 
# Plane 4
FULA mar_rad R802_09  1   1   1    F   F    1   1   1   1    1   1    F   F
FULA mar_rad R853_11  1   1   1    F   F    1   1   1   1    1   1    F   F
FULA mar_rad R858_12  1   1   1    F   F    1   1   1   1    1   1    F   F
FULA mar_rad R721_13  1   1   1    F   F    1   1   1   1    1   1    F   F
FULA mar_rad R852_14  1   1   1    F   F    1   1   1   1    1   1    F   F
FULA mar_rad R857_15  1   1   1    F   F    1   1   1   1    1   1    F   F
FULA mar_rad R736_16  1   1   1    F   F    1   1   1   1    1   1    F   F
# Plane 0
FULA mar_rad R851_17   1   1   1    F   F    F   F   F   F    F   F    F   F
FULA mar_rad R854_18   1   1   1    F   F    F   F   F   F    F   F    F   F
FULA mar_rad R720_19   1   1   1    F   F    F   F   F   F    F   F    F   F
FULA mar_rad R719_20   1   1   1    F   F    F   F   F   F    F   F    F   F
FULA mar_rad R855_21   1   1   1    F   F    F   F   F   F    F   F    F   F
FULA mar_rad R731_22   1   1   1    F   F    F   F   F   F    F   F    F   F
FULA mar_rad R732_23   1   1   1    F   F    F   F   F   F    F   F    F   F
FULA mar_rad R801_26   1   1   1    F   F    F   F   F   F    F   F    F   F





B2UD mar_rad all 365 365 365    0  0    0    0 365 365  365 365    0   0
FULA bak_file Week<WWWW>_B2UD<LAB>.bak
FUKA mar_neu all 365 365 365  0 0 0

 apr_svan all 0.001 0.001 0.001
  mar_svan all     0     0     0    ! Forces white noise

  rad_reset no

  app_ptid

  del_scra yes

TRAN apr_tran 1 1 1 0 0 0 


 apr_wob   1   1   0.1   0.1
 mar_wob 365 365 0 0
 apr_ut1 0.001 100
* use of -365 should de-couple UT1 from integrated LOD
 mar_ut1 1.e-9  -36500
UT1 apr_ut1 0.001 100
UT1 mar_ut1 1.e-9 36500

  app_ptid IERS20 +SEPT +OPT 

  descript IGS20 Back Soln
